shape = {}

function shape.Calculate()
   local hw = shape.width / 2
   local hh = shape.height / 2
   local r = shape.filletRad
   Line(-hw, -hh + r, -hw, hh - r)
   ArcA(-hw, hh - r, -hw + r, hh - r, math.pi/2)
   Line(-hw + r, hh, hw - r, hh)
   ArcA(hw - r, hh, hw - r, hh - r, math.pi/2)
   Line(hw, hh - r, hw, -hh + r)
   ArcA(hw, -hh + r, hw - r, -hh + r, math.pi/2)
   Line(hw - r, -hh, -hw + r, -hh)
   ArcA(-hw + r, -hh, -hw + r, -hh + r, math.pi/2)

   hw = (shape.holeHoriz * (shape.holeHNo - 1)) / 2
   hh = (shape.holeVert * (shape.holeVNo - 1)) / 2
   local x = -hw
   local y = hh
   for p=1,shape.holeHNo do
      Circle(x, y, shape.holeDia)
      x = x + shape.holeHoriz
   end
   x = -hw
   y = -hh
   for p=1,shape.holeHNo do
      Circle(x, y, shape.holeDia)
      x = x + shape.holeHoriz
   end
   x = -hw
   y = hh - shape.holeVert
   for q=1,shape.holeHNo do
		for p=2,shape.holeVNo - 1 do
			Circle(x, y, shape.holeDia)
			y = y - shape.holeVert
		end
		x = x + shape.holeHoriz
		y = hh - shape.holeVert
	end
end

AddNumControl("width", "Width", sc.unitLINEAR, 200, 0.1, 10000, "width.png")
AddNumControl("height", "Height", sc.unitLINEAR, 100, 0.1, 10000, "height.png")
AddNumControl("holeHNo", "Horizontal hole number", sc.unit0DECPLACE, 4, 2, 100, "hHoleNo.png")
AddNumControl("holeHoriz", "Horizontal hole spacing", sc.unitLINEAR, 40, 0.1, 10000, "hHole.png")
AddNumControl("holeVNo", "Vertical hole number", sc.unit0DECPLACE, 4, 2, 100, "vHoleNo.png")
AddNumControl("holeVert", "Vertical hole spacing", sc.unitLINEAR, 20, 0.1, 10000, "vHole.png")
AddNumControl("holeDia", "Hole diameter", sc.unitLINEAR, 10, 0.1, 10000, "holeDia.png")
AddNumControl("filletRad", "Fillet radius", sc.unitLINEAR, 10, 0.1, 10000, "fillet.png")


